/*
 * PlainDisk.java
 *
 * Created on May 31, 2006, 9:16 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package ags.disk;

import java.io.IOException;

/**
 * Derivation of a disk image with standard sector ordering
 * @author blurry
 */
public class PlainDisk extends Disk {
    // interleaved ordering
    /**
     * Order of sectors for this format
     */
    static int[] sectorOrder = {
        0x00, 0x0D, 0x0b, 0x09, 0x07, 0x05, 0x03, 0x01,
        0x0e, 0x0c, 0x0a, 0x08, 0x06, 0x04, 0x02, 0x0f
        /*
        0x00, 0x07, 0x0e, 0x06, 0x0d, 0x05, 0x0c, 0x04,
        0x0b, 0x03, 0x0a, 0x02, 0x09, 0x01, 0x08, 0x0f
         */
    };

    /**
     * Constructor (read disk image)
     * @param file Path of disk image
     * @throws java.io.IOException If disk image could not be read
     */
    public PlainDisk(String file) throws IOException {
        super(file);
    }
    
    /**
     * Translate plain disk image sector ordering
     * @param sectorNumber Physical (disk image) sector number
     * @return Logical (memory) sector number
     */
    protected int translateSectorNumber(int sectorNumber) {
        if (sectorNumber < 0 || sectorNumber >= SECTORS_PER_TRACK) {
            System.out.println("Sector "+sectorNumber+" is out of range!");
            return 0;
        }
//        System.out.println("Translating sector "+sectorNumber+" to "+sectorOrder[sectorNumber]);
        return sectorOrder[sectorNumber];
    }
}
